"""
flip_operators package

Provides the fundamental tick‑flip operators and associated helpers.
"""

# Import operators and helpers
from .renewal import renewal, F  # renewal (F) operator
from .sinking import S  # sink operator
from .distinction import distinction, X  # distinction (X) operator
from .sync import C  # sync operator (symmetric projection)
from .frame_coupling import Phi  # frame coupling operator (Phi = C ∘ X)
from .tick_state import TickState
from .graph_utils import load_boundary_graph, validate_graph

__all__ = [
    "renewal",
    "F",
    "S",
    "distinction",
    "X",
    "C",
    "Phi",
    "TickState",
    "load_boundary_graph",
    "validate_graph",
]
